<?php

function monnifycon($wtid,$username,$password,$contcode,$custname,$custphone,$custemail,$custdesc,$amt){
    
    $ch = curl_init();

    $data = array(
        'amount'=>$amt,
        'customerName'=>$custname,
        'customerPhoneNumber'=> $custphone,
        'customerEmail'=> $custemail,
        'paymentReference' => $wtid,
        'paymentDescription'=> $custdesc,
        'currencyCode'=>'NGN',
        'contractCode'=> $contcode
    );

    curl_setopt($ch, CURLOPT_URL, "https://api.monnify.com/api/v1/merchant/transactions/init-transaction");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);

    curl_setopt($ch, CURLOPT_POST, TRUE);

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
      "Content-Type: application/json",
      "Authorization: Basic ".base64_encode("$username:$password")
    ));

    $response = curl_exec($ch);
    $err = curl_error($ch);
    if($err){
      // there was an error contacting the Monnify API
      die ('no^' . $err);
    }

    curl_close($ch);


    $transaction = json_decode($response,true);

    if(@$transaction['responseMessage']=='success'){
        if(isset($transaction['responseBody']['transactionReference'])){
            $mnfycon= 'yes^'.$transaction['responseBody']['transactionReference'];
        }
        else{
            $mnfycon= 'no^Transaction reference not found (mon)';
        }
    }
    else{
        $mnfycon= 'no^Unable to connect (mon)';
    }

    return $mnfycon;
}

function genmnyfyacct($mnfyid,$username,$password){

    $ch = curl_init();

    $data = array(
        'bankCode'=> '058',
        'transactionReference' => $mnfyid
    );

    curl_setopt($ch, CURLOPT_URL, "https://api.monnify.com/api/v1/merchant/bank-transfer/init-payment");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
      "Content-Type: application/json",
      "Authorization: Basic ".base64_encode("$username:$password")
    ));

    $response = curl_exec($ch);
    $err = curl_error($ch);

    if($err){
      // there was an error contacting the Monnify API
      die ('no^' . $err);
    }

    curl_close($ch);


    $transaction = json_decode($response,true);

    if(@$transaction['responseMessage']=='success'){
        if(isset($transaction['responseBody']['accountNumber'])){
            $mnfyacct= "yes^".$transaction['responseBody']['accountNumber']."^".$transaction['responseBody']['bankName']."^".$transaction['responseBody']['accountName'];
        }
        else{
            $mnfyacct= 'no^Cannot generate account (mon)';
        }
    }
    else{
        $mnfyacct= 'no^Cannot connect (mon)';
    }

    return $mnfyacct;
}

function genMonnAcct($wtid,$username,$password,$contcode,$custname,$custphone,$custemail,$custdesc,$amt){

    $resp=monnifycon($wtid,$username,$password,$contcode,$custname,$custphone,$custemail,$custdesc,$amt);
    $result=explode("^",$resp);
    if($result[0]=='yes'){
        $payid=$result[1];
        $getacct=genmnyfyacct($payid,$username,$password);
        $pgetacct=explode("^",$getacct);
        if($pgetacct[0]=='yes'){
            return "yes^".$pgetacct[1]."^".$pgetacct[2]."^".$pgetacct[3]."^".$payid;
        }   
        else{
             return "no^".$pgetacct[1];
        }
    }
    else{
        return "no^".$result[1];
    }
}


function getmnfytrans($wtid,$username,$password){
    $ch = curl_init();  
    curl_setopt($ch, CURLOPT_URL, "https://api.monnify.com/api/v1/merchant/transactions/query?paymentReference=$wtid");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
      "Authorization: Basic ".base64_encode("$username:$password")
    ));
    
    $response = curl_exec($ch);
    $err = curl_error($ch);

    if($err){
      // there was an error contacting the Monnify API
      die ('no^' . $err);
    }
    curl_close($ch);

    
    $resp = json_decode($response, true);

    if(@$resp['responseMessage']=='success'){
        if($resp['responseBody']['paymentStatus']=='PAID' ){
            //action here
            $amtpaid=$resp['responseBody']['amountPaid'];
            $mnref=$resp['responseBody']['transactionReference'];
            return "yes^$amtpaid^$mnref";
        }
        else{
            $state=ucwords($resp['responseBody']['paymentStatus']);
            return "no^$state";
        }
    }
    else{
        return "no^unable to get transaction (mon)";
    }
    
    
}



?>