<?php
session_start();

require 'bridge.php';

require 'session_timeout.php';

require 'user_info.php';

require 'config.php';

extract($_GET);

if (isset($_POST['rperp'])) {
    extract($_POST);
    $_SESSION['xrperp'] = $rperp;
    header("location:transactions");
    exit;
}

if (isset($_SESSION['xrperp'])) {
    $rperp = $_SESSION['xrperp'];
}

if(isset($vx)){
    $vx=mysqli_real_escape_string($wole,$vx);
    mysqli_query($wole,"delete from wusertrans where tid='$vx'");
    if(isset($_SESSION['msearch']) && @$_SESSION['msearch']!=''){
        $search=$_SESSION['msearch'];
        unset($_SESSION['msearch']);
    }
}

if(isset($fx)){
    $fx=mysqli_real_escape_string($wole,$fx);
    $ccc=mysqli_query($wole,"select id,amt,uname,details from wusertrans where tid='$fx'");
    $rccc=mysqli_fetch_array($ccc);
    
    $poid=$rccc['id'];
    $cost=abs($rccc['amt']);
    $unm=$rccc['uname'];
    $reason="Refund: ".$rccc['details'];
    $rstatus="Completed";
    $wtid="wvtu_".uniqid();

    updateBalance($wtid,$unm,'platform',$cost,$reason,$rstatus,$wole);
    mysqli_query($wole,"update wusertrans set status='$rstatus' where id=$poid");

    echo "<script>alert('Operation Successful!')</script>";
    if(isset($_SESSION['msearch']) && @$_SESSION['msearch']!=''){
        $search=$_SESSION['msearch'];
        unset($_SESSION['msearch']);
    }
}

if (isset($search) && @$search!='') {
    

    $search = str_replace("\\", "", trim($search));
    $search = str_replace("'", "", trim($search));
    $search = str_replace("%", "", trim($search));

    $search=mysqli_real_escape_string($wole,$search);
    $_SESSION['msearch']=$search;
}

?>


<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Transactions</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="assets/css/theme.css">
    <!-- <link rel="stylesheet" href="./assets/css/smsxenda.css"> --><link rel="apple-touch-icon" sizes="180x180" href="./assets/favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/favicon/favicon-16x16.png">
  <link rel="manifest" href="assets/favicon/site.webmanifest">

  <!--Font Awesome styles -->
  <link href="assets/fonts/fontawesome/css/all.css" rel="stylesheet">
</head>

<body class="g-sidenav-show bg-gray-50">

    <!-- Sidenav Starts -->
    <?php
      include 'aside.php';
    ?>


    <!-- Sidenav Ends -->

    <!-- Main Content Starts -->
    <div class="main-content" id="panel">
        <?php include 'navbar.php' ?>
        <div class="container-fluid pt-3">
            <h5 class="pb-3 ms-2 ms-md-5"><i class="fas fa-arrow-left" onClick="history.back()"></i> Transactions</h5>
            To complete a particular pending or processing transaction, click its status.
            <form class="ms-3" id="filter" name="filter" action="" method="get">
                <div class="mb-3 search rounded-2 row d-flex align-items-center justify-content-center col-8 col-md-6">
                    <div class="col-9 m-0 p-0">
                        <input class="form-control form-control-sm" type="text" name="search" id="search" placeholder="Ref., Desc., Amount or Status" value="<?php echo @$search; ?>">
                    </div>
                    <div class="col-3 mt-3 p-0">
                        <button class="btn btn-primary" type="submit" id="request">
                            <i class="fas fa-search text-white"></i>
                        </button>
                    </div>


                </div>
            </form>

            <form id="rowsperpage" name="rowsperpage" method="post" style="padding-bottom: 5px">
                <div class='pagination' style="">
                    <font style="padding-right: 5px; margin-left: 8px; font-size: 16px">Limit to: </font>
                    <select id="rperp" name="rperp" style="font-size: 12px; border-radius: 4px" onchange="rpp()" style="color: var(--blue); border-color: var(--blue);" class="select">
                        <option value="10" <?php if (isset($rperp) && ($rperp) == '10') {
                                                echo "selected='selected'";
                                            } ?>>10 Records</option>
                        <option value="20" <?php if (isset($rperp) && ($rperp) == '20') {
                                                echo "selected='selected'";
                                            } ?>>20 Records</option>
                        <option value="50" <?php if (isset($rperp) && ($rperp) == '50') {
                                                echo "selected='selected'";
                                            } ?>>50 Records</option>
                        <option value="100" <?php if (isset($rperp) && ($rperp) == '100') {
                                                echo "selected='selected'";
                                            } ?>>100 Records</option>
                         <option value="200" <?php if (isset($rperp) && ($rperp) == '200') {
                                                echo "selected='selected'";
                                            } ?>>200 Records</option>
                        <option value="500" <?php if (isset($rperp) && ($rperp) == '500') {
                                                echo "selected='selected'";
                                            } ?>>500 Records</option>
                        
                    </select>
                </div>
            </form>


            <section class="border rounded-2 table-box">
                <div class="border-bottom p-2">
                    <h5 class="fs-6">Transaction History</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead>
                            <tr>
                               <th class="text-secondary">Time</th>
                              <th class="text-secondary">RefID</th>
                              <th class="text-secondary">User</th>
                              <th class="text-secondary">Details</th>
                              <th class="text-secondary">Amount</th>
                              <th class="text-secondary">Ini.Bal</th>
                              <th class="text-secondary">New Bal</th>
                              <th class="text-secondary">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (isset($rperp)) {
                                $perpagerec = $rperp;
                            } else {
                                $perpagerec = 10;
                            }


                            if (isset($_GET['page'])) {
                                $page = $_GET['page'];
                            } else {
                                $page = 1;
                            }


                            $startfrom = ($page - 1) * $perpagerec;

                            if (isset($search)) {
                                $search = mysqli_escape_string($linkage, $search);
                                $qt = mysqli_query($linkage, "SELECT * FROM wusertrans WHERE  (details LIKE '%$search%' OR tid LIKE '%$search%' OR amt LIKE '%$search%' OR status LIKE '%$search%') order by dtime desc limit $startfrom, $perpagerec");
                            } else {

                                $qt = mysqli_query($linkage, "SELECT * FROM wusertrans ORDER BY dtime DESC LIMIT $startfrom, $perpagerec");
                            }

                            $sn = $startfrom;

                            while ($rw = mysqli_fetch_array($qt)) {

                                $sn++;

                                if ($rw['status'] == 'Pending') {
                                    $statcol = '#5760F9';
                                }
                                
                                elseif ($rw['status'] == 'Completed' || $rw['status'] == 'Successful') {
                                    $statcol = '#26FA5D';
                                }
                                
                                elseif ($rw['status'] == 'Failed') {
                                    $statcol = '#FF0000';
                                }
                                
                                // elseif ($rw['status'] == 'Refunded') {
                                //     $statcol = 'Purple';
                                // }
                                
                                else {
                                    $statcol = 'purple';
                                }

                                $tid=$rw['tid'];
                                $comp='';
                                if($rw['status']=='Completed'){
                                    $comp=$rw['status'];
                                }
                                elseif($rw['status']=='Processing' || $rw['status']=='Pending'){
                                    $comp="<a href='#' style='color: white; cursor: pointer' onClick=displayPrompt('$tid')>".$rw['status']."</a>";
                                }

                                $cdetails =$rw['details'];
                                $username =$rw['uname'];
                                  $route =$rw['portaltype'];
                                  $route="($route)";

                                  $userfname='';
                                  $mm=mysqli_query($wole,"select fname from whatsappvtuuser where uname='$username'");
                                  $rmm=mysqli_fetch_array($mm);
                                  $userfname=$rmm['fname'];
                                
                                 echo "<tr style='text-align: left;'><td>" . $rw['dtime'] . "</td><td>" . $rw['tid'] . "</td><td>".$userfname."</td><td>" . $cdetails ."<br>$route" . "</td><td>₦" . number_format((float)$rw['amt'], 2, '.', ',') . "</td><td>₦" . number_format((float)$rw['inibal'], 2, '.', ',') . "</td><td>₦" . number_format((float)$rw['newbal'], 2, '.', ',') . "</td><td><center><span style='font-size:11px; padding:1px; padding-left: 6px; padding-right: 6px; background-color: " . $statcol . "; border-radius: 10px; color: white'>" . $comp . "</span></center></td></tr>";
                            }



                            ?>
                        </tbody>
                    </table>
            </section>
                    <nav aria-label="Page navigation example" class="mt-2">
                        <ul class="pagination pageno justify-content-end">
                            <?php
                            if (isset($search)) {
                                $search = mysqli_escape_string($linkage, $search);
                                $qr = mysqli_query($linkage, "SELECT * FROM wusertrans WHERE (details LIKE '%$search%' OR tid LIKE '%$search%' OR amt LIKE '%$search%' OR status LIKE '%$search%') order by dtime");
                            } else {

                                $qr = mysqli_query($linkage, "SELECT * FROM wusertrans ORDER BY dtime DESC LIMIT $startfrom, $perpagerec");
                            }

                            $total_records = mysqli_num_rows($qr);

                            if ($total_records < 1) {
                                echo "<li class='page-item'>
                                <a class='page-link'>First</a>
                            </li>
                            <li class='page-item'>
                                <a class='page-link'>Prev</a>
                            </li>
                            <li class='page-item'><a class='page-link'>1</a></li>
                            <li class='page-item'><a class='page-link'>of</a></li>
                            <li class='page-item'><a class='page-link'>1</a></li>
                            <li class='page-item'>
                                <a class='page-link' href='#''>Next</a>
                            </li>
                            <li class='page-item'>
                                <a class='page-link' href='#'>Last</a>
                            </li>";
                            } else {
                                //echo "$total_records";

                                //echo "</br>";
                                // Number of pages required.
                                $total_pages = ceil($total_records / $perpagerec);
                                $pagLink = "";


                                if ($page == 1) {
                                    echo "<li class='page-item'>
                                <a class='page-link'>First</a>
                            </li>";
                                } else {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?search=" . $search . "&page=1'>First</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?page=1'>First</a>
                            </li>";
                                    }
                                }


                                if ($page >= 2) {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?search=" . $search . "&page=" . ($page - 1) . "'>Prev</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?page=" . ($page - 1) . "'>Prev</a>
                            </li>";
                                    }
                                } else {
                                    echo "<li class='page-item'>
                                <a class='page-link'>Prev</a>
                            </li>";
                                }


                                echo  "<li class='page-item'><a class='page-link'>" . $page . "</a></li>
                            <li class='page-item'><a class='page-link'>of</a></li>
                            <li class='page-item'><a class='page-link'>" . $total_pages . "</a></li>
                            <li class='page-item'>";




                                if ($page < $total_pages) {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?search=" . $search . "&page=" . ($page + 1) . "'>Next</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?page=" . ($page + 1) . "'>Next</a>
                            </li>";
                                    }
                                } else {
                                    echo "<li class='page-item'>
                                <a class='page-link'>Next</a>
                            </li>";
                                }

                                if ($page < $total_pages) {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?search=" . $search . "&page=" . ($total_pages) . "'>Last</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?page=" . ($total_pages) . "'>Last</a>
                            </li>";
                                    }
                                } else {
                                    echo "<li class='page-item'>
                                <a class='page-link'>Last</a>
                            </li>";
                                }
                            }
                            ?>

                        </ul>
                    </nav>
        </div>
        
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/perfect-scrollbar.min.js"></script>
        <script src="assets/js/smooth-scrollbar.min.js"></script>
        <script src="assets/js/smsxenda.min.js"></script>
        <script src="assets/js/chartjs.min.js"></script>

    <script>
        function rpp() {
            document.rowsperpage.submit();
        }

        function displayPrompt(m) {
          const choice = prompt("What do you want to do to "+m+"?\n\n1. Mark as Completed\n2. Refund\n\nEnter 1 or 2?\n");

          if (choice === "1") {
            window.location="transactions?vx="+m;
          } else if (choice === "2") {
            window.location="transactions?fx="+m;
          } 
        }

        function AdisplayPrompt(m) {
          var choice = confirm("Do you want to mark as completed?");
          if(choice==1){
            window.location="transactions?vx="+m;
          }
          
        }

    </script>

</body>
</html>