<?php
session_start();

require 'bridge.php';

require 'session_timeout.php';

require 'user_info.php';

require 'config.php';

extract($_GET);

if (isset($_POST['rperp'])) {
    extract($_POST);
    $_SESSION['xrperp'] = $rperp;
    header("location:pending");
    exit;
}

if (isset($_SESSION['xrperp'])) {
    $rperp = $_SESSION['xrperp'];
}

if(isset($dx)){
    $dx=mysqli_real_escape_string($wole,$dx);
    mysqli_query($wole,"delete from paygatetrans where wtid='$dx'");
    if(isset($_SESSION['xsearch']) && @$_SESSION['xsearch']!=''){
        $search=$_SESSION['xsearch'];
        unset($_SESSION['xsearch']);
    }

    echo "<script>alert('Operation Successful!')</script>";
}


if (isset($search)) {
    
    $search = str_replace("\\", "", trim($search));
    $search = str_replace("'", "", trim($search));
    $search = str_replace("%", "", trim($search));

    $search=mysqli_real_escape_string($wole,$search);
    $_SESSION['xsearch']=$search;
}

?>


<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>ChatTopup</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="assets/css/theme.css">
    <!-- <link rel="stylesheet" href="./assets/css/smsxenda.css"> --><link rel="apple-touch-icon" sizes="180x180" href="./assets/favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/favicon/favicon-16x16.png">
  <link rel="manifest" href="assets/favicon/site.webmanifest">

  <!--Font Awesome styles -->
  <link href="assets/fonts/fontawesome/css/all.css" rel="stylesheet">
</head>

<body class="g-sidenav-show bg-gray-50">

    <!-- Sidenav Starts -->
    <?php
      include 'aside.php';
    ?>


    <!-- Sidenav Ends -->

    <!-- Main Content Starts -->
    <div class="main-content" id="panel">
        <?php include 'navbar.php' ?>
        <div class="container-fluid pt-3">
            <h5 class="pb-3 ms-2 ms-md-5"><i class="fas fa-arrow-left" onClick="history.back()"></i> Gateway Transactions</h5>
            To update the status of a particular transactions, just click its status<br>
            When you Requery, it would first check the status of the payment on the gateway before updating and applying the amount.
            <form class="ms-3" id="filter" name="filter" action="" method="get">
                <div class="mb-3 search rounded-2 row d-flex align-items-center justify-content-center col-8 col-md-6">
                    <div class="col-9 m-0 p-0">
                        <input class="form-control form-control-sm" type="text" name="search" id="search" placeholder="product, Desc., Amount or Status" value="<?php echo @$search; ?>">
                    </div>
                    <div class="col-3 mt-3 p-0">
                        <button class="btn btn-primary" type="submit" id="request">
                            <i class="fas fa-search text-white"></i>
                        </button>
                    </div>


                </div>
            </form>
            <form id="rowsperpage" name="rowsperpage" method="post" style="padding-bottom: 5px">
                <div class='pagination' style="">
                    <font style="padding-right: 5px; margin-left: 8px; font-size: 16px">Limit to: </font>
                    <select id="rperp" name="rperp" style="font-size: 12px; border-radius: 4px" onchange="rpp()" style="color: var(--blue); border-color: var(--blue);" class="select">
                        <option value="10" <?php if (isset($rperp) && ($rperp) == '10') {
                                                echo "selected='selected'";
                                            } ?>>10 Records</option>
                        <option value="20" <?php if (isset($rperp) && ($rperp) == '20') {
                                                echo "selected='selected'";
                                            } ?>>20 Records</option>
                        <option value="50" <?php if (isset($rperp) && ($rperp) == '50') {
                                                echo "selected='selected'";
                                            } ?>>50 Records</option>
                        <option value="100" <?php if (isset($rperp) && ($rperp) == '100') {
                                                echo "selected='selected'";
                                            } ?>>100 Records</option>
                    </select>
                </div>
            </form>
            <section class="border rounded-2 table-box">
                <div class="border-bottom p-2">
                    <h5 class="fs-6">Gateway Transactions</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead>
                            <tr>
                                <th class="text-secondary">S/N</th>
                                <th class="text-secondary">Date</th>
                                <th class="text-secondary">User</th>
                                <th class="text-secondary">Gateway</th>    
                                <th class="text-secondary">PayID</th>                          
                                <th class="text-secondary">Accno</th> 
                                <th class="text-secondary">Bank</th> 
                                <th class="text-secondary">Amount</th> 
                                <th class="text-secondary">Status</th> 
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (isset($rperp)) {
                                $perpagerec = $rperp;
                            } else {
                                $perpagerec = 10;
                            }


                            if (isset($_GET['page'])) {
                                $page = $_GET['page'];
                            } else {
                                $page = 1;
                            }


                            $startfrom = ($page - 1) * $perpagerec;

                            if (isset($search)) {
                                $search = mysqli_escape_string($linkage, $search);
                                $qt = mysqli_query($linkage, "SELECT * FROM paygatetrans WHERE (wtid LIKE '%$search%' or status LIKE '%$search%' or accno LIKE '%$search%')  order by id desc limit $startfrom, $perpagerec");
                            } else {

                                $qt = mysqli_query($linkage, "SELECT * FROM paygatetrans ORDER BY id desc LIMIT $startfrom, $perpagerec ");
                            }

                            $sn = $startfrom;

                            while ($rw = mysqli_fetch_array($qt)) {

                                $sn++;
                                
                                $rstatus=$rw['status'];
                                if (strtolower($rstatus) == 'pending') {
                                    $statcol = '#5760F9';
                                }
                                
                                elseif (strtolower($rstatus) == 'completed' || strtolower($rstatus) == 'successful') {
                                    $statcol = '#26FA5D';
                                }
                                
                                elseif (strtolower($rstatus) == 'failed') {
                                    $statcol = '#FF0000';
                                }
                                
                                $pgid=$rw['pgid'];
                                $tid=$rw['wtid'];
                                $comp='';
                                if(strtolower($rw['status'])=='completed'){
                                    $comp=strtolower($rw['status']);
                                }
                                elseif(strtolower($rw['status'])=='processing' || strtolower($rw['status'])=='pending'){
                                    $comp="<a href='#' style='color: white; cursor: pointer' onClick=displayPrompt('$tid')>".strtolower($rw['status'])."</a>";
                                }

                                
                                $username =$rw['uname'];
                                 
                                  $userfname='';
                                  $mm=mysqli_query($wole,"select fname from whatsappvtuuser where uname='$username'");
                                  $rmm=mysqli_fetch_array($mm);
                                  $userfname=$rmm['fname'];

                                  $pgname='';
                                  $mm=mysqli_query($wole,"select pgname from paygate where id=$pgid");
                                  $rmm=mysqli_fetch_array($mm);
                                  $pgname=$rmm['pgname'];

                                  $cbs="S_".$tid;
                                  $bcb="<span id='$cbs'>$comp</div>";
                                                               
                                echo "<tr style='text-align: left;'><td>" . $sn ."</td><td>" . $rw['dtime'] . "</td><td>" . $userfname ."</td><td>" . $pgname . "</td><td>" . $tid . "</td><td>" . $rw['accno'] ."</td><td>".$rw['bank'] . "</td><td>" . number_format((float)$rw['amt'], 2, '.', ',')  ."</center></td></td><td><center><span id='$tid' style='font-size:11px; padding:1px; padding-left: 6px; padding-right: 6px; background-color: " . $statcol . "; border-radius: 10px; color: white'>" . $bcb . "</span></center></td></tr>";
                            }



                            ?>
                        </tbody>
                    </table>
            </section>
                    <nav aria-label="Page navigation example" class="mt-2">
                        <ul class="pagination pageno justify-content-end">
                            <?php
                            if (isset($search)) {
                                $search = mysqli_escape_string($linkage, $search);
                                $qr = mysqli_query($linkage, "SELECT * FROM paygatetrans WHERE (wtid LIKE '%$search%' or status LIKE '%$search%' or accno LIKE '%$search%') order by id desc limit $startfrom, $perpagerec") or die(mysqli_error($linkage));
                            } else {

                                $qr = mysqli_query($linkage, "SELECT * FROM paygatetrans ORDER BY id desc LIMIT $startfrom, $perpagerec");
                            }

                            $total_records = mysqli_num_rows($qr);

                            if ($total_records < 1) {
                                echo "<li class='page-item'>
                                <a class='page-link'>First</a>
                            </li>
                            <li class='page-item'>
                                <a class='page-link'>Prev</a>
                            </li>
                            <li class='page-item'><a class='page-link'>1</a></li>
                            <li class='page-item'><a class='page-link'>of</a></li>
                            <li class='page-item'><a class='page-link'>1</a></li>
                            <li class='page-item'>
                                <a class='page-link' href='#''>Next</a>
                            </li>
                            <li class='page-item'>
                                <a class='page-link' href='#'>Last</a>
                            </li>";
                            } else {
                                //echo "$total_records";

                                //echo "</br>";
                                // Number of pages required.
                                $total_pages = ceil($total_records / $perpagerec);
                                $pagLink = "";


                                if ($page == 1) {
                                    echo "<li class='page-item'>
                                <a class='page-link'>First</a>
                            </li>";
                                } else {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?search=" . $search . "&page=1'>First</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?page=1'>First</a>
                            </li>";
                                    }
                                }


                                if ($page >= 2) {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='transactions?search=" . $search . "&page=" . ($page - 1) . "'>Prev</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?page=" . ($page - 1) . "'>Prev</a>
                            </li>";
                                    }
                                } else {
                                    echo "<li class='page-item'>
                                <a class='page-link'>Prev</a>
                            </li>";
                                }


                                echo  "<li class='page-item'><a class='page-link'>" . $page . "</a></li>
                            <li class='page-item'><a class='page-link'>of</a></li>
                            <li class='page-item'><a class='page-link'>" . $total_pages . "</a></li>
                            <li class='page-item'>";




                                if ($page < $total_pages) {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?search=" . $search . "&page=" . ($page + 1) . "'>Next</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?page=" . ($page + 1) . "'>Next</a>
                            </li>";
                                    }
                                } else {
                                    echo "<li class='page-item'>
                                <a class='page-link'>Next</a>
                            </li>";
                                }

                                if ($page < $total_pages) {
                                    if (isset($search)) {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?search=" . $search . "&page=" . ($total_pages) . "'>Last</a>
                            </li>";
                                    } else {
                                        echo "<li class='page-item'>
                                <a class='page-link' href='pending?page=" . ($total_pages) . "'>Last</a>
                            </li>";
                                    }
                                } else {
                                    echo "<li class='page-item'>
                                <a class='page-link'>Last</a>
                            </li>";
                                }
                            }
                            ?>

                        </ul>
                    </nav>
        </div>
        
        <script src="assets/js/popper.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/perfect-scrollbar.min.js"></script>
        <script src="assets/js/smooth-scrollbar.min.js"></script>
        <script src="assets/js/smsxenda.min.js"></script>
        <script src="assets/js/chartjs.min.js"></script>

    <script>
        function rpp() {
            document.rowsperpage.submit();
        }


        function displayPrompt(m) {
          const choice = prompt("What do you want to do to "+m+"?\n\n1. Requery on Gateway\n2. Remove\n\nEnter 1, 2 or 3?\n");

          if (choice === "1") {
            //window.location="pending?cx="+m;
            reprocess(m);
          } else if (choice === "1") {
            window.location="pending?rx="+m;
          }
          else if (choice === "2") {
            var conf=confirm("Are you sure want to delete?\nAction not reversible!");
            if(conf==1){
                window.location="pending?dx="+m;
            }
            
          } 
        }

        var xhr = new XMLHttpRequest();

        function reprocess(m) {
          // Your logic for reprocessing
            var conf=confirm("Are you sure you want to Requery "+ m +"?");
            if(conf==0){
                exit;
            }

            var spn="S_"+m;
            var initxt=document.getElementById(spn).innerHTML;
            document.getElementById(spn).innerHTML="<br><small>Working...</small>";
          xhr.open("GET", "pendit.php?x=p&v=" + encodeURIComponent(m), true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    //alert(xhr.responseText);                    
                    if (xhr.responseText.trim() === "Completed") {                         
                        document.getElementById(m).innerHTML=xhr.responseText;    
                        document.getElementById(m).style.backgroundColor='#26FA5D';                  
                        document.getElementById(m).innerHTML=xhr.responseText;
                    }
                    else{
                        alert(xhr.responseText);
                        document.getElementById(spn).innerHTML=initxt;
                    }
                    
                }
            };
            xhr.send();

        }
    </script>

</body>
</html>