<?php
session_start();

require 'bridge.php';

$query = mysqli_prepare($linkage, "SELECT * FROM resetpass_token WHERE xtoken = ? ");  
mysqli_stmt_bind_param($query, 's', $aotoken);

$aotoken='';
if(isset($_SESSION['toaken'])){
  $aotoken=$_SESSION['toaken'];
  unset($_SESSION['toaken']);

  if (!preg_match('/^[A-Za-z0-9]{88,88}$/', $aotoken) ) {
    $_SESSION['sendlink']="<center><p style='color: red'>Invalid password reset link!</p></center>";
    header("location: forgot-password");
    mysqli_close($linkage);    
    exit;
    }


  $aotoken=mysqli_real_escape_string($linkage,$aotoken);

  mysqli_stmt_execute($query);
  $result = mysqli_stmt_get_result($query);

  if(mysqli_num_rows($result)==0){
    $_SESSION['sendlink']="<center><p style='color: red'>Invalid password reset link!</p></center>";
    header("location: forgot-password");
    mysqli_close($linkage);    
    exit;
  }
  
  $su=mysqli_fetch_array($result);
  $uname= $su['uname'];
  $texpire= $su['texpire'];
  $status= $su['status'];

  if ($status=='used') {
    $_SESSION['sendlink']="<center><p style='color: red'>Password reset link already used!</p></center>";
    header("location: forgot-password");
    mysqli_close($linkage);
    exit;
  }
  
  if ($status=='cancelled') {
    $_SESSION['sendlink']="<center><p style='color: red'>Kindly check email for new link!</p></center>";
    header("location: forgot-password");
    mysqli_close($linkage);
    exit;
  }
  
  if ($status!='unused') {
    $_SESSION['sendlink']="<center><p style='color: red'>An error has occurred!</p></center>";
    header("location: forgot-password");
    mysqli_close($linkage);
    exit;
  }

  
  date_default_timezone_set("Africa/Lagos");
  $dtime=date('Y-m-d H:i:s');

  if ($dtime>$texpire) {
    $_SESSION['sendlink']="<center><p style='color: red'>Password reset link has expired!</p></center>";
    header("location: forgot-password");
    mysqli_close($linkage);
    exit;
  }

  $_SESSION['uname']=$uname;
  $_SESSION['ootoken']=$aotoken;
  $_SESSION['texpire']=$texpire;
  header("location: reset-password");
  mysqli_close($linkage);
  exit;

}

else {
 	header("location: forgot-password");
 	mysqli_close($linkage);
 	exit;
}

?>