<?php
session_start();

require 'bridge.php';

require 'session_timeout.php';

require 'user_info.php';
require 'config.php';


date_default_timezone_set("Africa/Lagos");

$alert='';
if(isset($_SESSION['verisuccess'])){
  $alert=$_SESSION['verisuccess'];
  unset($_SESSION['verisuccess']);
}

if (isset($vnin)) {
  $alert=$vnin;
}

$msg2='';
if(isset($_SESSION['submsg1'])){
  $msg2=$_SESSION['submsg1'];
  unset($_SESSION['submsg1']);
  unset($_SESSION['uspr']);
}


$_SESSION['uspr']=array();

if(!isset($_SESSION['ex']) ){
    header ("location: catalogue");
}
else{
    $ex=$_SESSION['ex'];
    $query3= mysqli_prepare($linkage, "select prname, prdescp, prprice, praccess from products where pid=?");
    mysqli_stmt_bind_param($query3,'s',$ex);
    mysqli_stmt_execute($query3);
    $result = mysqli_stmt_get_result($query3);
    
    if($result->num_rows==1){
        $row = $result->fetch_assoc();

        $_SESSION['uspr'][0]=$row['prname'];
        $_SESSION['uspr'][1]=$row['prdescp'];
        $_SESSION['uspr'][2]=$row['praccess'];
        $_SESSION['uspr'][3]=$row['prprice'];
    }
    else{
        header("location: dashboard");
        exit;
    }
    
}
/**
//add product only if subscription
$qsub=mysqli_query($wole,"select * from wsubscribep where vid='$vid'");
if(mysqli_num_rows($qsub)==1){
  $rsub=mysqli_fetch_array($qsub);
  $pvexpdate=$rsub['waexpdate'];
  $pex=date("d-m-Y H:i:sa",strtotime($pvexpdate));
  $avail=1;

  $currentsub="<p><b>Subscription Expiration: $pex</b></p>";
  $whatsgroup="<p ><a href='https://chat.whatsapp.com/ClvVNwcPvuR0pij7DPDlPH' target='_blank' style='color: blue'><b>Click <u>here</u> to Join Whatsapp Group </b></a></p>";

}
else{
  echo "<script>alert('You have not subscribe for the Products package.'); window.location='subscribep'</script>";  
}
**/


if(isset($_POST['prdes']) && isset($_POST['prname']) ){
  extract($_POST);
  $prname=sanitizeInput($prname);
  $prdes=sanitizeInput($prdes);
  $prdes=substr($prdes, 0, 350);
  $praccess=sanitizeInput($praccess);

   $imgstate='';

  $_SESSION['uspr'][0]=$prname;
  $_SESSION['uspr'][1]=$prdes;
  $_SESSION['uspr'][2]=$praccess;

  if (validateNumber($prprice)) {
    if($prprice<100){
        $_SESSION['submsg1']="<p style='color: red'>Price should not be less than 100.</p>";
        header("location: eproducts");
    }
    else{
        $ddate=date("Y-m-d H:i:s");
        $id=0;
        $pind=array("PRDS","PRTS");
        $ch=rand(0,1);

        $lid = (int)date('myhis');
        $prid=$pind[$ch].$lid;
        $prphone='08068777302';
        $prurl="";
        
        
        // Set the maximum allowed file size (in bytes)
        $maxFileSize = 500 * 1024; // 500 KB
        
        // Set the desired image dimensions
        $targetWidth = 500;
        $targetHeight = 500;
        
        // Check if a file was uploaded
        if (isset($_FILES['image']['tmp_name'])) {
            $tmpName = $_FILES['image']['tmp_name'];
            $fileName = $_FILES['image']['name'];
            $fileSize = $_FILES['image']['size'];
            $fileType = $_FILES['image']['type'];
            $fileExt = pathinfo($fileName, PATHINFO_EXTENSION);
        
            // Check if the file size is within the allowed limit
            if ($fileSize > $maxFileSize) {
                //echo "Error: File size exceeds the maximum allowed limit (500 KB).";
                $_SESSION['submsg1']="<p style='color: red'>File size exceeds the maximum allowed limit (500 KB)</p>";
                header("location: eproducts");
                exit;
            } else {
                // Check if the file is a valid image
                $allowedTypes = ['image/jpeg', 'image/png'];
                if (!in_array($fileType, $allowedTypes)) {
                    //echo "Error: Invalid file type. Only JPG and PNG images are allowed.";
                     $_SESSION['submsg1']="<p style='color: red'>Invalid file type. Only JPG and PNG images are allowed</p>";
                    header("location: eproducts");
                } 
                else {
                    
                    // Check file contents for image signatures
                    $imageData = file_get_contents($tmpName);
                    if (!getimagesizefromstring($imageData)) {
                        //echo "Error: Invalid image file contents.";
                        $_SESSION['submsg1']="<p style='color: red'>Invalid image file contents.</p>";
                        header("location: eproducts");
                        exit;
                    }
                    
                    // Check file contents for image signatures using GD
                    $image = imagecreatefromstring($imageData);
                    if (!$image) {
                        //echo "Error: Invalid image file contents.";
                        $_SESSION['submsg1']="<p style='color: red'>Invalid image contents.</p>";
                        header("location: eproducts");
                        exit;
                    }

           
                    // Generate a unique filename to avoid conflicts
                    $myfile= $_SESSION['ex'].".".$fileExt;
            
                    $uniqueFilename = $myfile;
        
                    // Create a temporary directory to store the uploaded file
                    $tempDir = '../../files.whatsvtubot.com/images/';
                    if (!is_dir($tempDir)) {
                        mkdir($tempDir);
                    }
        
                    // Move the uploaded file to the temporary directory
                    $targetPath = $tempDir . $uniqueFilename;
                    if (move_uploaded_file($tmpName, $targetPath)) {
                        // Resize and compress the image using GD library
                        $srcImage = imagecreatefromstring(file_get_contents($targetPath));
                        $newImage = imagecreatetruecolor($targetWidth, $targetHeight);
                        imagecopyresampled($newImage, $srcImage, 0, 0, 0, 0, $targetWidth, $targetHeight, imagesx($srcImage), imagesy($srcImage));
        
                        // Save the resized and compressed image
                        imagejpeg($newImage, $targetPath, 90); // 90% quality (adjust as needed)
        
                        // Get the compressed file size
                        $compressedFileSize = filesize($targetPath);
                        
                        $imgstate='';
                        //echo "Image uploaded and resized successfully. Compressed file size: " . round($compressedFileSize / 1024, 2) . " KB";
                    } else {
                        $imgstate= "<br>Failed to upload image.";
                    }
                }
            }
        }
        
        
        
        $query2 = mysqli_prepare($linkage, "update products set prname=?, prdescp=?, prprice=?, praccess=? where pid=?");
        mysqli_stmt_bind_param($query2,'ssiss',$prname,$prdes,$prprice,$praccess,$_SESSION['ex']);
        mysqli_stmt_execute($query2);

        $_SESSION['submsg1']="<p style='color: blue'>Product Updated!</p>";
        header("location: eproducts");
    }
  } 
  else {
    $_SESSION['submsg1']="<p style='color: red'>Invalid price!</p>";
    header("location: eproducts");
  }

    
}

function sanitizeInput($input) {
    // Remove potentially harmful characters
    $input = htmlspecialchars($input, ENT_QUOTES, 'UTF-8');
    $input = strip_tags($input);

    // Remove unwanted characters (adjust as needed)
    //$input = preg_replace('/[^a-zA-Z0-9\s!@,]/', '', $input);

    // Trim leading and trailing whitespace
    $input = trim($input);

    return $input;
}

function validateNumber($input) {
    // Check if the input is a valid number
    if (!is_numeric($input)) {
        return false;
    }

    // Check if the number contains a decimal point
    if (strpos($input, '.') !== false) {
        // Ensure the decimal point is not at the beginning or end
        if (strpos($input, '.') === 0 || strrpos($input, '.') === strlen($input) - 1) {
            return false;
        }
    }

    return true;
}

function datacurl($Url){
  if (!function_exists('curl_init')){
  die('CURL is not installed!');
  }
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $Url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  $output = curl_exec($ch);
  curl_close($ch);
  return $output;
}

function sendPSMS($message,$recv){
  $recv=urlencode($recv);
  $message=urlencode(stripslashes($message)); 
  
  //$url= "http://ngnr.connectbind.com/bulksms/bulksms?username=ibkf-ibktech&password=ifemi170&type=0&dlr=1&destination=$recv&source=$sender&message=$message";
  $url="https://www.mobileairtimeng.com/smsapi/customsms.php?smsto=$recv&message=$message";
  @$gback=datacurl($url);
  return $gback;
}





?>



<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Update Product</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="assets/css/theme.css">
    <!-- <link rel="stylesheet" href="assets/css/smsxenda.css"> --><link rel="apple-touch-icon" sizes="180x180" href="assets/favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/favicon/favicon-16x16.png">
  <link rel="manifest" href="assets/favicon/site.webmanifest">

    <!--Font Awesome styles -->
    <link href="assets/fonts/fontawesome/css/all.css" rel="stylesheet">
    <style>

    </style>
</head>

<body class="g-sidenav-show bg-gray-50">

    <!-- Sidenav Starts -->
  <?php
    include 'aside.php';
  ?>


    <!-- Sidenav Ends -->

    <!-- Main Content Starts -->
    <div class="main-content" id="panel">
        <?php
          include 'navbar.php';

        ?>
        <div class="container-fluid pt-3">
            <h5 class="pb-3 ms-2 ms-md-5"><i class="fas fa-arrow-left" onClick="history.back()"></i> Subscribe</h5>
            <div class="container mt-0">
            </div>
        </div>
    

      <div class="card rounded-4  col-md-8 mb-3 mx-auto">
        <div class="m-2 pt-3 text-center head_text">
          <h3 class="fw-bolder ">Update Product</span></h3>
        </div>
        <div class="form-msg" style="display: flex; justify-content: center;" id="msg2"><?php echo @$msg2 ?></div>
  
            <form class="p-1 pt-2 mt-0" id="updbank" name="updbank" method="post" enctype="multipart/form-data" onsubmit="return upd()">
              
              <div class="mb-3">
                   <label class="form-label"><b>Title</b></label><br>
                   <span style="font-size: 10pt">This is the name of your product.</span>
                   <input type="text" class="form-control" id="prname" name="prname" value="<?php echo @$_SESSION['uspr'][0] ?>"  required>                
              </div>
              <div class="mb-3">
                   <label class="form-label"><b>Description</b></label><br>
                   <span style="font-size: 10pt">Keep it short and make it engaging. Not more than 350 characters</span>
                   <textarea name="prdes" id="prdes" class="form-control" placeholder="Enter your text..." required onkeyup="countchar()"><?php echo @$_SESSION['uspr'][1] ?></textarea>
                   <div style="font-size: 9pt"><span id="cntprdes">0</span>/350 characters</div>
              </div>
              <div class="mb-3">
                   <label class="form-label"><b>Price</b></label><br>
                   <input type="number" class="form-control" id="prprice" name="prprice" value="<?php echo @$_SESSION['uspr'][3] ?>"  required>                
              </div>
              <div class="mb-3">
                   <label class="form-label"><b>Access Information or Product</b></label><br>
                   <span style="font-size: 10pt">This is what the customers will receive.<br>For instance, if you are selling a digital product or resource, you can upload it to Google drive or any other service and put the download link here.<br></span>
                   <textarea name="praccess" id="preaccess" class="form-control" required><?php echo @$_SESSION['uspr'][2] ?></textarea>
              </div> 
              
              <div class="mb-3">
                  <label class="form-label"><b>Upload image (500kb max, 500x500px)</b></label><br>
                  <span style="font-size: 10pt">If you have uploaded image then you do not need to upload again except you want to change the previous image.</span><br>
                  <input type="file" name="image" id="image">
             </div>
            

              <div class="mb-0" id="div-acc">
                  
              </div>

              
              <button type="submit" id="upbutt" class="btn btn-primary w-100 mt-3" >Update</button>
            </form>
          
            <?php unset($_SESSION['uspr']);  ?>
           
        </div>

      
    </div>


    </div>

        <script src="assets/js/popper.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/perfect-scrollbar.min.js"></script>
        <script src="assets/js/smooth-scrollbar.min.js"></script>
        <script src="assets/js/smsxenda.min.js"></script>
        <script src="assets/js/chartjs.min.js"></script>

  <script>


 // Make sure the DOM is fully loaded before adding the event listener
    document.addEventListener('DOMContentLoaded', function() {
        const textarea = document.getElementById('prdes');
        const countSpan = document.getElementById('cntprdes');

        // Listen for the input event to update the character count
        textarea.addEventListener('input', function() {
            const textLength = textarea.value.length;
            countSpan.textContent = textLength;

            // Prevent input over 250 characters
            if (textLength > 350) {
                textarea.value = textarea.value.substring(0, 350);
                countSpan.textContent = 350; // Limit the displayed count
            }
        });
    });

    function upd(){
      var conf=confirm("Are you sure you want to continue?");
      if(conf==0){
        return false;
      }
      document.getElementById('upbutt').innerHTML = 'Processing...';
    }


   
  </script>


  <script>
        <?php if($alert!='') {echo "alert('".@$alert."');";} ?>
  </script>

</body>
</html>