<?php
// Initial admin credentials (already configured securely in the environment)
$host = 'localhost'; // Hostname (usually localhost)
$initialAdminUsername = getenv('DB_ADMIN_USER'); // Existing admin username
$initialAdminPassword = getenv('DB_ADMIN_PASS'); // Existing admin password

// Database to manage
$dbName = 'wvtubot'; 

// Generate a new random admin username and password
$newAdminUsername = 'admin_' . bin2hex(random_bytes(4)); // Random 8-character username
$newAdminPassword = bin2hex(random_bytes(12)); // Random 24-character password

try {
    // Connect to MySQL using the initial admin credentials
    $conn = new mysqli($host, $initialAdminUsername, $initialAdminPassword);

    // Check connection
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // Create the new admin user
    $createUserSql = "CREATE USER '$newAdminUsername'@'%' IDENTIFIED BY '$newAdminPassword'";
    if (!$conn->query($createUserSql)) {
        throw new Exception("Error creating new admin user: " . $conn->error);
    }

    // Grant full privileges to the new admin user
    $grantPrivilegesSql = "GRANT ALL PRIVILEGES ON *.* TO '$newAdminUsername'@'%' WITH GRANT OPTION";
    if (!$conn->query($grantPrivilegesSql)) {
        throw new Exception("Error granting privileges to new admin user: " . $conn->error);
    }

    // Flush privileges to apply changes
    if (!$conn->query("FLUSH PRIVILEGES")) {
        throw new Exception("Error flushing privileges: " . $conn->error);
    }

    echo "New admin user created successfully.\n";
    echo "Username: $newAdminUsername\n";
    echo "Password: $newAdminPassword\n";

    // Use the new admin credentials for further operations, if needed
    // For example, you can store these credentials securely in a file or environment variable
} catch (Exception $e) {
    echo "An error occurred: " . $e->getMessage();
} finally {
    // Close the connection
    if (isset($conn) && $conn->ping()) {
        $conn->close();
    }
}
?>
